/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IEnumValues;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.redstone.IRedstoneReader;
import com.hrznstudio.titanium.api.redstone.IRedstoneState;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.block.redstone.RedstoneManager;
import com.hrznstudio.titanium.block.redstone.RedstoneState;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.bundle.TankInteractionBundle;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.RedstoneControlButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IndustrialMachineTile<T extends IndustrialMachineTile<T>>
extends MachineTile<T>
implements IRedstoneReader {
    @Save
    private TankInteractionBundle<IndustrialMachineTile> tankBundle;
    @Save
    private RedstoneManager<RedstoneAction> redstoneManager = new RedstoneManager((IEnumValues)RedstoneAction.IGNORE, false);
    private RedstoneControlButtonComponent<RedstoneAction> redstoneButton = new RedstoneControlButtonComponent(154, 84, 14, 14, () -> this.redstoneManager, () -> this);
    private boolean tankBundleAdded = false;

    public IndustrialMachineTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)basicTileBlock.getLeft()).get(), (BlockEntityType)((RegistryObject)basicTileBlock.getRight()).get(), blockPos, blockState);
        this.addButton((ButtonComponent)this.redstoneButton);
    }

    public void addTank(FluidTankComponent<T> tank) {
        super.addTank(tank);
        if (!this.tankBundleAdded) {
            this.tankBundle = new TankInteractionBundle(() -> this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY), 175, 94, (BasicTile)this, 10);
            this.addBundle((IComponentBundle)this.tankBundle);
            this.tankBundleAdded = true;
        }
    }

    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return !this.hasAugmentInstalled(AugmentTypes.SPEED);
        }
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.EFFICIENCY)) {
            return !this.hasAugmentInstalled(AugmentTypes.EFFICIENCY);
        }
        return super.canAcceptAugment(augment);
    }

    public RedstoneManager<RedstoneAction> getRedstoneManager() {
        return this.redstoneManager;
    }

    public IRedstoneState getEnvironmentValue(boolean strongPower, Direction direction) {
        if (strongPower) {
            if (direction == null) {
                return this.f_58857_.m_46753_(this.f_58858_) ? RedstoneState.ON : RedstoneState.OFF;
            }
            return this.f_58857_.m_46616_(this.f_58858_, direction) ? RedstoneState.ON : RedstoneState.OFF;
        }
        return this.f_58857_.m_46755_(this.f_58858_) > 0 ? RedstoneState.ON : RedstoneState.OFF;
    }

    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
        super.onNeighborChanged(blockIn, fromPos);
        this.redstoneManager.setLastRedstoneState(this.getEnvironmentValue(false, null).isReceivingRedstone());
    }

    public IAssetProvider getAssetProvider() {
        return IndustrialAssetProvider.INSTANCE;
    }
}

